﻿prompt PL/SQL Developer import file
prompt Created on 28 02, 2013 by Vu Van Cuong
set feedback off
set define off
prompt Dropping TBLLETTERFORMAT_GTW...
drop table TBLLETTERFORMAT_GTW cascade constraints;
prompt Dropping TBLREPLYFORMAT_GTW...
drop table TBLREPLYFORMAT_GTW cascade constraints;
prompt Creating TBLLETTERFORMAT_GTW...
create table TBLLETTERFORMAT_GTW
(
  FIELD_NO         NUMBER(8),
  FIELD_HEADING    VARCHAR2(150 CHAR),
  FIELD_HEADINGVN  VARCHAR2(150 CHAR),
  FIELD_TYPE       VARCHAR2(5 CHAR),
  FIELD_SIZE       NUMBER(8),
  FIELD_CODE       VARCHAR2(50 CHAR) not null,
  TBLFILES         NUMBER(8),
  TBLLETTER_MSG    NUMBER(8),
  TBLLETTERMSG_GTW NUMBER(8),
  REQUIRED         CHAR(1) not null
);

prompt Creating TBLREPLYFORMAT_GTW...
create table TBLREPLYFORMAT_GTW
(
  FIELD_NO          NUMBER(8),
  FIELD_HEADING     VARCHAR2(150 CHAR),
  FIELD_HEADINGVN   VARCHAR2(150 CHAR),
  FIELD_TYPE        VARCHAR2(5 CHAR),
  FIELD_SIZE        NUMBER(8),
  FIELD_CODE        VARCHAR2(50 CHAR) not null,
  TBLFILES          NUMBER(8),
  TBLLETTER_MSGX    NUMBER(8),
  TBLLETTERMSGX_GTW NUMBER(8),
  REQUIRED          CHAR(1) not null
);

prompt Loading TBLLETTERFORMAT_GTW...
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (1, null, 'Số tiền chuyển', 'N', 20, 'AMOUNT_ORG', 17, 0, 17, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (2, null, 'Khóa tin điện', 'N', 8, 'MSG_KEY', 0, 1, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (3, null, 'Mã Người ký duyệt giao dịch', 'AN', 16, 'APPR_ID', 19, 24, 20, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (4, null, 'Thời gian người phê duyệt tiến hành phê duyệt giao', 'AN', 14, 'APPR_TIME', 21, 27, 24, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (5, null, 'ID Ngân hàng gửi lệnh', 'N', 8, 'O_CI_ID', 0, 3, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (6, null, 'Thời điểm gửi tin điện', 'AN', 14, 'SD_TIME', 3, 7, 4, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (6, null, 'ID Ngân hàng nhận lệnh', 'N', 8, 'R_CI_ID', 0, 4, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (7, 'Mã trạng thái kiểm tra giao dịch', 'Mã trạng thái kiểm tra giao dịch', 'AN', 2, 'CHECK_CODE', 0, 0, 1, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (8, null, 'Ngày giao dịch', 'AN', 8, 'TRX_DATE', 8, 0, 9, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (9, null, 'Ngày làm việc của hệ thống', 'AN', 8, 'TRX_DATE', 8, 10, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (10, null, 'Tên file đi / đến', 'AN', 100, 'FILE_NAME', 0, 0, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (11, null, 'Tên file', 'AN', 25, 'FILE_NAME', 0, 0, 3, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (12, null, 'Cờ chuyển sang Core Banking', 'N', 1, 'GTW_FLAG', 0, 31, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (13, null, 'Nội dung lệnh tra soát', 'AN', 210, 'LETTER_CONTENT', 9, 12, 10, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (14, null, 'Tên file', 'AN', 25, 'FILE_NAME', 0, 0, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (15, null, 'Thời điểm tạo giao dịch', 'AN', 14, 'CREATE_TIME', 20, 26, 21, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (16, null, 'Mã Loại tiền', 'AN', 3, 'CURRENCY_ORG', 16, 0, 16, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (17, null, 'Loại tin điện', 'AN', 4, 'MSG_TYPE', 0, 2, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (18, null, 'Loại cập nhật', 'AN', 1, 'INPUT_TYPE', 0, 30, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (19, null, 'Chữ ký của hệ thống ngoài', 'AN', 200, 'EX_E_SIGN', 18, 0, 18, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (20, null, 'Mã trạng thái lỗi', 'N', 4, 'ERR_STATUS', 0, 6, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (21, null, 'Định danh ngân hành gửi lệnh', 'AN', 12, 'O_CI_CODE', 6, 0, 7, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (22, null, 'Trạng thái xử lý', 'AN', 15, 'TRX_STATUS', 0, 13, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (23, 'Tình trạng tạo file, kết quả file đến', 'Tình trạng tạo file, kết quả file đến', 'AN', 1, 'CREATE_FILE_RESULT_FLAG', 0, 0, 2, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (24, null, 'Định danh ngân hàng nhận lệnh', 'AN', 12, 'R_CI_CODE', 7, 0, 8, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (25, null, 'Số bút toán', 'AN', 10, 'RELATION_NO_ORG', 10, 0, 11, '1');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (26, null, 'Chữ ký', 'AN', 200, 'E_SIGN', 0, 11, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (27, null, 'Mã trả lời xử lý', 'N', 4, 'RESPONSE_CODE', 4, 8, 5, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (28, null, 'Số hiệu giao dịch', 'N', 8, 'SERIAL_NO', 5, 9, 6, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (29, null, 'Tiến trình', 'AN', 2, 'PROCESS', 0, 15, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (30, null, 'MAC', 'AN', 28, 'MAC', 0, 14, 19, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (31, null, 'Loại giao dịch', 'AN', 6, 'TRX_TYPE', 2, 5, 27, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (32, null, 'ID của người tạo lệnh chuyển tiền', 'AN', 16, 'ORIG_ID', 0, 23, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (33, 'COntent From File', 'Nội dung lệnh chuyển tiền từ file', 'AN', 4000, 'CONTENTFROMFILE', 0, 0, 22, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (34, null, 'File giao dich', 'AN', 25, 'TRX_FILE_NAME', 0, 16, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (35, null, 'ID Ngân hàng gửi lệnh gốc', 'N', 8, 'O_CI_ID_ORG', 0, 20, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (36, null, 'Loại giao dịch của lệnh chuyển tiền gốc', 'AN', 6, 'TRX_TYPE_ORG', 15, 17, 23, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (37, null, 'Số hiệu giao dịch của lệnh gốc', 'N', 8, 'SERIAL_NO_ORG', 14, 19, 15, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (38, null, 'Ngày giao dịch của lệnh gốc', 'AN', 8, 'TRX_DATE_ORG', 13, 18, 14, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (39, null, 'Lý do thoái lệnh', 'AN', 210, 'MSG_REASON', 0, 25, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (40, null, 'ID ngân hàng gửi lệnh gián tiếp', 'N', 12, 'O_INDIRECT_ORG', 0, 0, 25, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (41, null, 'ID Ngân hàng nhận lệnh gián tiếp', 'N', 12, 'R_INDIRECT_ORG', 0, 0, 26, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (42, null, 'Định danh Ngân hàng gửi lệnh gián tiếp', 'AN', 22, 'O_INDIRECT_ORG', 0, 21, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (43, null, 'Định danh Ngân hàng nhận lệnh gián tiếp', 'AN', 22, 'R_INDIRECT_ORG', 0, 22, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (44, null, 'Định danh ngân hành gửi lệnh gốc', 'AN', 12, 'O_CI_CODE_ORG', 11, 0, 12, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (45, null, 'Định danh ngân hàng nhận lệnh gốc', 'AN', 12, 'R_CI_CODE_ORG', 12, 0, 13, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (46, null, 'Mã Người ký duyệt giao dịch', 'AN', 16, 'APPR_IN_ID', 0, 29, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (47, null, 'Thời gian người phê duyệt tiến hành phê duyệt giao', 'AN', 14, 'APPR_IN_TIME', 0, 28, 0, '0');
insert into TBLLETTERFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSG, TBLLETTERMSG_GTW, REQUIRED)
values (48, null, 'Loại bản ghi', 'AN', 2, 'REC_TYPE', 1, 0, 0, '0');
commit;
prompt 49 records loaded
prompt Loading TBLREPLYFORMAT_GTW...
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (1, null, 'Số tiền chuyển', 'N', 20, 'AMOUNT_ORG', 17, 0, 18, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (2, null, 'Khóa tin điện', 'N', 8, 'MSG_KEY', 0, 1, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (3, null, 'Mã Người ký duyệt giao dịch', 'AN', 16, 'APPR_ID', 24, 17, 25, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (4, null, 'Thời gian người phê duyệt tiến hành phê duyệt giao', 'AN', 14, 'APPR_TIME', 26, 20, 30, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (5, null, 'ID Ngân hàng gửi lệnh', 'N', 8, 'O_CI_ID', 0, 25, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (6, null, 'Thời điểm gửi tin điện', 'AN', 14, 'SD_TIME', 3, 5, 4, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (6, null, 'ID Ngân hàng nhận lệnh', 'N', 8, 'R_CI_ID', 0, 26, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (7, 'Mã trạng thái kiểm tra giao dịch', 'Mã trạng thái kiểm tra giao dịch', 'AN', 2, 'CHECK_CODE', 0, 0, 1, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (8, null, 'Ngày giao dịch', 'AN', 8, 'TRX_DATE', 0, 0, 9, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (9, null, 'Ngày làm việc của hệ thống', 'AN', 8, 'TRX_DATE', 8, 8, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (10, null, 'Tên file đi / đến', 'AN', 100, 'FILE_NAME', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (11, null, 'Tên file', 'AN', 25, 'FILE_NAME', 0, 0, 3, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (12, null, 'Cờ chuyển sang Core Banking', 'N', 1, 'GTW_FLAG', 0, 30, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (13, null, 'Nội dung lệnh tra soát', 'AN', 210, 'LETTER_CONTENT', 9, 14, 10, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (14, null, 'Tên file', 'AN', 25, 'FILE_NAME', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (15, null, 'Thời điểm tạo giao dịch', 'AN', 14, 'CREATE_TIME', 25, 19, 26, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (16, null, 'Mã Loại tiền', 'AN', 3, 'CURRENCY_ORG', 16, 0, 17, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (17, null, 'Loại tin điện', 'AN', 4, 'MSG_TYPE', 0, 2, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (18, null, 'Loại cập nhật', 'AN', 1, 'INPUT_TYPE', 0, 29, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (19, null, 'Chữ ký của hệ thống ngoài', 'AN', 200, 'EX_E_SIGN', 23, 0, 23, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (20, null, 'Mã trạng thái lỗi', 'N', 4, 'ERR_STATUS', 0, 4, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (21, null, 'Định danh ngân hành gửi lệnh', 'AN', 12, 'O_CI_CODE', 6, 0, 7, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (22, null, 'Trạng thái xử lý', 'AN', 15, 'TRX_STATUS', 0, 11, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (23, 'Tình trạng tạo file, kết quả file đến', 'Tình trạng tạo file, kết quả file đến', 'AN', 1, 'CREATE_FILE_RESULT_FLAG', 0, 0, 2, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (24, null, 'Định danh ngân hàng nhận lệnh', 'AN', 12, 'R_CI_CODE', 7, 0, 8, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (25, null, 'Số bút toán', 'AN', 10, 'RELATION_NO_ORG', 11, 0, 12, '1');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (26, null, 'Chữ ký', 'AN', 200, 'E_SIGN', 0, 9, 27, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (27, null, 'Mã trả lời xử lý', 'N', 4, 'RESPONSE_CODE', 4, 6, 5, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (28, null, 'Số hiệu giao dịch', 'N', 8, 'SERIAL_NO', 5, 7, 6, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (29, null, 'Tiến trình', 'AN', 2, 'PROCESS', 0, 13, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (30, null, 'MAC', 'AN', 28, 'MAC', 0, 12, 24, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (31, null, 'Loại giao dịch', 'AN', 6, 'TRX_TYPE', 2, 3, 31, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (32, null, 'ID của người tạo lệnh chuyển tiền', 'AN', 16, 'ORIG_ID', 0, 16, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (33, 'COntent From File', 'Nội dung lệnh chuyển tiền từ file', 'AN', 4000, 'CONTENTFROMFILE', 0, 0, 28, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (34, null, 'File giao dich', 'AN', 25, 'TRX_FILE_NAME', 0, 15, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (35, null, 'ID Ngân hàng gửi lệnh gốc', 'N', 8, 'O_CI_ID_ORG', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (36, null, 'Loại giao dịch của lệnh chuyển tiền gốc', 'AN', 6, 'TRX_TYPE_ORG', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (37, null, 'Số hiệu giao dịch của lệnh gốc', 'N', 8, 'SERIAL_NO_ORG', 15, 0, 16, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (38, null, 'Ngày giao dịch của lệnh gốc', 'AN', 8, 'TRX_DATE_ORG', 14, 0, 15, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (39, null, 'Lý do thoái lệnh', 'AN', 210, 'MSG_REASON', 0, 18, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (40, null, 'ID ngân hàng gửi lệnh gián tiếp', 'N', 8, 'O_INDIRECT_ORG', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (41, null, 'ID Ngân hàng nhận lệnh gián tiếp', 'N', 8, 'R_INDIRECT_ORG', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (42, null, 'Định danh Ngân hàng gửi lệnh gián tiếp', 'AN', 22, 'O_INDIRECT_ORG', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (43, null, 'Định danh Ngân hàng nhận lệnh gián tiếp', 'AN', 22, 'R_INDIRECT_ORG', 0, 22, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (44, null, 'Định danh ngân hành gửi lệnh gốc', 'AN', 12, 'O_CI_CODE_ORG', 12, 0, 13, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (45, null, 'Định danh ngân hàng nhận lệnh gốc', 'AN', 12, 'R_CI_CODE_ORG', 13, 0, 14, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (46, null, 'Mã Người ký duyệt giao dịch', 'AN', 16, 'APPR_IN_ID', 0, 28, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (47, null, 'Thời gian người phê duyệt tiến hành phê duyệt giao', 'AN', 14, 'APPR_IN_TIME', 0, 27, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (48, null, 'ID Ngân hàng gửi lệnh gốc', 'N', 8, 'LET_O_CI_ID', 0, 0, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (49, null, 'Loại giao dịch của lệnh chuyển tiền gốc', 'AN', 6, 'LET_TRX_TYPE', 0, 24, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (50, null, 'Số hiệu giao dịch của lệnh gốc', 'N', 8, 'LET_SERIAL_NO', 0, 21, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (51, null, 'Ngày giao dịch của lệnh gốc', 'AN', 8, 'LET_TRX_DATE', 0, 23, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (52, null, 'ID Ngân hàng gửi lệnh gốc', 'N', 8, 'O_CI_CODE_LET', 18, 0, 19, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (53, null, 'Loại giao dịch của lệnh chuyển tiền gốc', 'AN', 6, 'TRX_TYPE_LET', 22, 0, 29, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (54, null, 'Số hiệu giao dịch của lệnh gốc', 'N', 8, 'SERIAL_NO_LET', 21, 0, 22, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (55, null, 'Ngày giao dịch của lệnh gốc', 'AN', 8, 'TRX_DATE_LET', 20, 0, 21, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (56, null,'Thời gian nhận lệnh', 'AN', 14, 'RCI_TIME', 0, 10, 0, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (57, null, 'Nội dung lệnh tra loi', 'AN', 210, 'REPLY_CONTENT', 10, 0, 11, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (58, null, 'ID Ngân hàng nhan lệnh gốc', 'N', 8, 'R_CI_CODE_LET', 19, 0, 20, '0');
insert into TBLREPLYFORMAT_GTW (FIELD_NO, FIELD_HEADING, FIELD_HEADINGVN, FIELD_TYPE, FIELD_SIZE, FIELD_CODE, TBLFILES, TBLLETTER_MSGX, TBLLETTERMSGX_GTW, REQUIRED)
values (59, null, 'Loại bản ghi', 'AN', 2, 'REC_TYPE', 1, 0, 0, '0');
commit;
prompt 60 records loaded
set feedback on
set define on
prompt Done.

drop table TBLGENKEY_LETTER cascade constraints;
drop table TBLGEN_LETTER cascade constraints;

create table TBLGENKEY_LETTER
(
  SERV_CODE  VARCHAR2(2) not null,
  CURRENTKEY NUMBER(8) not null,
  CURRENYEAR VARCHAR2(2 CHAR) not null
);
alter table TBLGENKEY_LETTER  add constraint TBLGENKEY_LETTER_PK primary key (CURRENTKEY, SERV_CODE, CURRENYEAR);

create table TBLGEN_LETTER
(
  TRX_DATE   VARCHAR2(8 CHAR) not null,
  TRX_SERIAL NUMBER(8) not null,
  RELATION_B NUMBER(8) not null
);
alter table TBLGEN_LETTER  add constraint TBLGEN_LETTER_PK primary key (TRX_DATE, RELATION_B, TRX_SERIAL);

insert into TBLGENKEY_LETTER (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('HM',(select DECODE(max(substr(msg_key,5,8)),null,1 ,MAX(substr(msg_key,5,8))+1) from tblletter_msg where msg_key like 'HM13%'),'13');
insert into TBLGENKEY_LETTER (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('HS',(select DECODE(max(substr(msg_key,5,8)),null,1 ,MAX(substr(msg_key,5,8))+1) from tblletter_msgx where msg_key like 'HS13%'),'13');
insert into TBLGENKEY_LETTER (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('LM',(select DECODE(max(substr(msg_key,5,8)),null,1 ,MAX(substr(msg_key,5,8))+1) from tblletter_msg where msg_key like 'LM13%'),'13');
insert into TBLGENKEY_LETTER (SERV_CODE, CURRENTKEY, CURRENYEAR) values ('LS',(select DECODE(max(substr(msg_key,5,8)),null,1 ,MAX(substr(msg_key,5,8))+1) from tblletter_msgx where msg_key like 'LS13%'),'13');
insert into TBLGEN_LETTER (TRX_DATE, TRX_SERIAL, RELATION_B) values ((select value from tblenv_control where type='GLOBAL_DATE'),(select DECODE(max(substr(serial_no,2,8)),null,1,MAX(substr(serial_no,2,8))+1) from tblletter_msg where trx_date=(select value from tblenv_control where type='GLOBAL_DATE')), 0);
commit;

ALTER TABLE tblletter_msg ADD INPUT_TYPE VARCHAR2(1);
ALTER TABLE tblletter_msg ADD GTW_FLAG CHAR(1);
ALTER TABLE tblletter_msgx ADD INPUT_TYPE VARCHAR2(1);
ALTER TABLE tblletter_msgx ADD GTW_FLAG CHAR(1);


alter table TBLTRANSACTIONMSG_ORG add constraint TBLTRANSACTIONMSG_ORG_PK_1 unique (TRX_DATE, O_CI_ID, RELATION_NO) deferrable novalidate ;