package sbv.messages.securities;

import java.io.UnsupportedEncodingException;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashAlgorithm {
    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; i++) {
            int halfbyte = (data[i] >>> 4) & 0x0F;
            int two_halfs = 0;
            do {
                if ((0 <= halfbyte) && (halfbyte <= 9))
                    buf.append((char)('0' + halfbyte));
                else
                    buf.append((char)('a' + (halfbyte - 10)));
                halfbyte = data[i] & 0x0F;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
    
    public static String convertUTF8(String str) {
      StringBuffer ostr = new StringBuffer();  
      for (int i = 0; i < str.length(); i++) {
          char ch = str.charAt(i);  
          if ((ch >= 0x0020) &&
              (ch <= 0x007e)) // Does the char need to be converted to unicode?
          {
              ostr.append(ch); // No.
          } else // Yes.
          {
              ostr.append("\\u"); // standard unicode format.
              String hex =
                  Integer.toHexString(str.charAt(i) & 0xFFFF); // Get hex value of the char.
              for (int j = 0; j < 4 - hex.length();
                   j++) // Prepend zeros because unicode requires 4 digits
                  ostr.append("0");
              ostr.append(hex.toLowerCase()); // standard unicode format.
              //ostr.append(hex.toLowerCase(Locale.ENGLISH));
          }
      }
        return (new String(ostr));
    }
    
    public static String SHA1(String text) throws NoSuchAlgorithmException,
                                                  UnsupportedEncodingException {
        byte[] t = text.getBytes("UTF-8");
    
        MessageDigest md;
        md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(t, 0, t.length);
        sha1hash = md.digest();
        return convertToHex(sha1hash);
    }
    
    public static byte[] SHA1(byte[] bText) throws NoSuchAlgorithmException,
                                                  UnsupportedEncodingException {
        MessageDigest md;
        md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(bText, 0, bText.length);
        sha1hash = md.digest();
        return sha1hash;
    }
    
    public static byte[] SHA256(byte[] bText) throws NoSuchAlgorithmException,
                                                  UnsupportedEncodingException {
        MessageDigest md;
        md = MessageDigest.getInstance("SHA-256");
        byte[] sha256hash = new byte[40];
        md.update(bText, 0, bText.length);
        sha256hash = md.digest();
        return sha256hash;
    }
    
    public static String MD5(String text)throws NoSuchAlgorithmException,
                                                  UnsupportedEncodingException {
         String digest = null;         
         MessageDigest md = MessageDigest.getInstance("MD5");
         byte[] hash = md.digest(text.getBytes("UTF-8"));         
          //converting byte array to Hexadecimal String
         StringBuilder sb = new StringBuilder(2*hash.length);
         for(byte b : hash){
             sb.append(String.format("%02x", b&0xff));               
         }        
         digest = sb.toString();         
         return digest;
    }
}
