package sbv.messages.securities;

import java.security.PrivateKey;
import java.security.Signature;

import java.text.SimpleDateFormat;

import java.util.Calendar;

public class SignMsg {
    private static final String ALGORITHM = "SHA256withRSA";
    public static String signMsg(String sSource,
                                 PrivateKey privateKey) {
        byte[] bSource = null;
        byte[] bSourceSHA256 = null;
        byte[] bSign = null;
        String bSignBase64 = null;
        try {
            //1.Lay ma nhi phan voi ma UTF-8 chuoi vao sSource
            bSource = sSource.getBytes("UTF-8");
            //2.Bam chuoi nhi phan voi thuat toan SHA256
            bSourceSHA256 = HashAlgorithm.SHA256(bSource);
            //3.Ky len chuoi sSource
            bSign = signing(bSourceSHA256, privateKey);
            //4.Chuyen doi chu ky dang nhi phan sang Base64
            bSignBase64 = Base64.base64Encode(bSign);
        } catch (Exception ex) {
            System.out.println("[" + getCurrentDateTimeNow() +
                               "][signMSg][" + ex.getMessage() + "]");
        }
        return bSignBase64;
    }
    
    public static String signMsg(byte[] bSource,
                                 PrivateKey privateKey) {
        byte[] bSign = null;
        String bSignBase64 = null;
        try {
            //1.Ky len chuoi sSource
            bSign = signing(bSource, privateKey);
            //2.Chuyen doi chu ky dang nhi phan sang Base64
            bSignBase64 = Base64.base64Encode(bSign);
        } catch (Exception ex) {
            System.out.println("[" + getCurrentDateTimeNow() +
                               "][signMSg][" + ex.getMessage() + "]");
        }
        return bSignBase64;
    }
    
    private static byte[] signing(byte[] bSource, 
                                  PrivateKey privateKey) {
        byte[] bSign = null;
        try {
            Signature sha1_rsa =
                Signature.getInstance(ALGORITHM);
            sha1_rsa.initSign(privateKey);
         
            sha1_rsa.update(bSource);
            bSign = sha1_rsa.sign();
        } catch (Exception ex) {
            System.out.println("[" + getCurrentDateTimeNow() +
                               "][signing][" + ex.getMessage() + "]");
        }
        return bSign;
    }
    
    private static String getCurrentDateTimeNow() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }
}
